/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.dialog.comp.PasswordFieldWithRestriction;
import DE.siemens.ad.logo.util.LogoError;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class UDFPasswordFieldWithRestriction
extends PasswordFieldWithRestriction {
    public UDFPasswordFieldWithRestriction(int maxLength) {
        super(maxLength);
    }

    protected Document createDefaultModel() {
        return new UDFPasswordDocument();
    }

    protected boolean isValidString(String str) {
        if (str.length() > this.maxLength) {
            return false;
        }
        Pattern pattern = Pattern.compile("[A-Za-z\\d_\\-]{1," + this.maxLength + "}");
        Matcher isMatch = pattern.matcher(str);
        if (!isMatch.matches()) {
            new LogoError(this, "dialog.error.udfPasswordField.wrongChar", "Invalid password. Please input numbers or letters.").display();
            return false;
        }
        return true;
    }

    protected class UDFPasswordDocument
    extends PlainDocument {
        protected UDFPasswordDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String currentString = this.getText(0, this.getLength());
            String tempString = currentString.substring(0, offs) + str + currentString.substring(offs);
            if (UDFPasswordFieldWithRestriction.this.isValidString(tempString)) {
                super.insertString(offs, str, a);
            } else {
                UDFPasswordFieldWithRestriction.this.getToolkit().beep();
            }
        }
    }
}

